/*
 *******************************************************
 application:		WAP Scan (uses wspget)
 author:		srk (srk@atstake.com)
 version:		0.1
 comments:              28-Nov-2001
			Here is the scanner I wrote - it just 
			calls system("wspget...") for each 
			port - it checks if the host exists 
			first by looking for a port that should 
			be closed (TCP 1 - wont work for IRIX 
			boxes) and seeing if we get an error 
			back straight away, or if we have to 
			wait for the gw to time out. Maybe better 
			to look for port 80, as this will also 
			return straight away if it's open or 
			closed, but will only timeout if it's 
			filtered or the host doesn't exist.
 *******************************************************
*/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

double wspscan(char *, char *, char *, int);

int
main(int argc, char *argv[])
{
int portlist[] = {22,23,25,79,80,111,139,443,6000,0};
char *wap_gw;
char *wap_port;
char *host;
int i;

printf("oo0 @stake wap pentesting tookit 0oo\n");
printf("wspscan - v0.1 \n");
printf("author: srk (srk@atstake.com)\n");

if(argc != 4)
{
fprintf(stderr,"\nWAP gateway 	  - required\n");
fprintf(stderr,"WAP server port   - required\n");
fprintf(stderr,"End host	  - required\n\n");
fprintf(stderr,"syntax:	  %s <wap gateway> <server port> <end host to scan>\n", argv[0]);
fprintf(stderr,"example:  %s 10.1.1.1 9200 wap.atstake.lan\n",argv[0]);
exit(1);
}

wap_gw = argv[1];
wap_port = argv[2];
host = argv[3];

if(wspscan(wap_gw, wap_port, host, 1) > 30) {
printf("\n.result\nserver does not appear to exist\n.end\n");
exit(0);
}

for(i=0; portlist[i] != 0; i++)
wspscan(wap_gw, wap_port, host, portlist[i]);

printf("\n.end\n");
return 0;
}

double
wspscan(char *wap_gw, char *wap_port, char *host, int port)
{
time_t start;
time_t end;
char cmd[2048];
char start_str[128];
char end_str[128];

sprintf(cmd, "wspget %s %s http://%s:%d/ get", wap_gw, wap_port, host, port);

start = time(NULL);
system(cmd);
end = time(NULL);

strftime(start_str, sizeof(start_str), "%H:%M:%S", localtime(&start));
strftime(end_str, sizeof(end_str), "%H:%M:%S", localtime(&end));

printf("\n.result ip: %s port: %d start: %s stop: %s diff: %f\n\n", host, port, start_str, end_str, difftime(end, start)); 

return difftime(end, start);
}
